import java.util.Scanner;
import java.util.ArrayList;
import java.io.File;
import java.text.DecimalFormat;

public class Problem_1_Sluggers {

    public static void main(String[] args) {
        
        try {
            DecimalFormat df = new DecimalFormat("#.000"); // to format the output
        
            Scanner scanner = new Scanner(new File("C:\\Users\\Mike\\Desktop\\problem_1_sluggers_DATA10.txt"));
            ArrayList<String> list = new ArrayList<String>();

            // read in the file to the ArrayList
            while (scanner.hasNextLine()) {
                list.add(scanner.nextLine());
            }
            
            // print the season name and then remove it from the list
            System.out.println(list.get(0) + "\n====================");
            list.remove(0);
            
            // sum of each team's averages
            double sumOfBatterAverages = 0, sumOfSluggerAverages = 0;
            
            for (String team : list) {
                
                String[] teamStats = team.split("\\s+"); // array of this specific team's stats
                
                System.out.print(teamStats[0] + ": "); // print the team name
                
                int E = Integer.parseInt(teamStats[2]); // at-bats
                int H = Integer.parseInt(teamStats[4]); // total hits
                int B = Integer.parseInt(teamStats[5]); // total two-base hits
                int C = Integer.parseInt(teamStats[6]); // total two-base hits
                int D = Integer.parseInt(teamStats[7]); // total two-base hits
                int A = H - B - C - D; // total one-base hits is the total hits subtract all the other base hits

                // ba --> batter average; sa --> slugger average
                double ba = (double)H / E; // number of hits / number of at-bats (remember to parse to a double to avoid integer division)
                double sa = (A + 2*B + 3*C + 4*D) / (double)E; // using their formula (remember to parse to a double to avoid integer division)
                                                               // one-base hits is multiplied by 1, two base-hits is multiplied by 2, etc.
                                                               // each base is worth a point
                
                 // add this team's batter/slugger average to the sum of all the batter/slugger averages
                sumOfBatterAverages += ba;
                sumOfSluggerAverages += sa;
                
                System.out.println(df.format(ba) + " " + df.format(sa)); // print the formatted averages
            }
            
            System.out.println("====================");
            
             // 10 teams, so the average of all the teams batter/slugger averages is the sum of them all, divided by 10
            double batterAverage = sumOfBatterAverages / 10;
            double sluggerAverage = sumOfSluggerAverages / 10;
            
            // print out the formatted total batter/slugger averages of all the teams
            System.out.print("Big 10 Av: " + df.format(batterAverage) + " " + df.format(sluggerAverage));
            
        } catch (Exception e) {
            System.out.println("Exception");
        }
        
    }
}
