import java.io.File;
import java.util.ArrayList;
import java.util.Scanner;

public class Problem_1_Take_A_Number {

    public static void main(String[] args) {

        try {

            ArrayList<String> list = new ArrayList<String>();

            // read in the file to the ArrayList
            Scanner file = new Scanner(new File("C:\\Users\\Mike\\Desktop\\DATA10.txt"));
            while (file.hasNextLine()) {
                list.add(file.nextLine());
            }

            int n = Integer.parseInt(list.get(0)); // initial next ticket number
            list.remove(0); // remove first number from list
            list.remove(list.size() - 1); // remove "EOF" from list

            int takes = 0, serves = 0;

            for (String s : list) {

                if (s.trim().equalsIgnoreCase("CLOSE")) {

                    System.out.print( String.valueOf(takes) + " "); // people late
                    System.out.print( String.valueOf(takes - serves) + " "); // people not served

                    // old solution for accounting for overflow. doesn't work because each overflow of 1000 causes this to be 1 more number off (1000 goes to 1, not 0)
                    // this solution for overflow is now in the else clause below
                    /*n += takes;
                    if (n > 999) { // have to refill the dispenser
                        n = 1 + (n % 1000); // get the overflow tickets
                    }*/

                    System.out.println( String.valueOf(n) ); // next available ticket number

                    takes = serves = 0;
                } else {

                    if (s.trim().equalsIgnoreCase("TAKE")) {
                        takes++;
                        n++;
                        // account for overflow
                        if (n > 999) { // have to refill the dispenser
                            n = 1 + (n - 1000); // get the overflow tickets
                        }
                    } else if (s.trim().equalsIgnoreCase("SERVE")) {
                        serves++;
                    }
                }
            }

        } catch (Exception e) {
            e.printStackTrace();
            System.out.println("Exception");
        }
        
    }
}