### USING ITERATION ###

# returns the nth term in the Fibonacci sequence
def fibonacci(n):
    i = 0
    j = 1
    for term in range(1, n):
        temp = i
        i = j
        j += temp
    return j

print(fibonacci(1)) # 1
print(fibonacci(2)) # 1
print(fibonacci(6)) # 8
print(fibonacci(12)) # 144

### USING RECURSION ###

# params: i and j are intial two Fibonacci terms; n is the nth term from i
# return: the nth term of the Fibonacci sequence (starting from i = 1st term)
def fibonacci(i, j, n):
    if (n > 0):
        return fibonacci(j, i+j, n-1) # next term; reduce the number of terms left
    else: # completed all terms
        return i

print(fibonacci(0, 1, 1)) # 1
print(fibonacci(0, 1, 2)) # 1
print(fibonacci(0, 1, 6)) # 8
print(fibonacci(0, 1, 12)) # 144